<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die(json_encode(["success" => false, "message" => "User ID required"]));

$query = "SELECT * FROM transactions WHERE user_id = :user_id";

if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $query .= " AND date BETWEEN :start_date AND :end_date";
}

$query .= " ORDER BY date DESC, id DESC";

$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);

if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $stmt->bindParam(":start_date", $_GET['start_date']);
    $stmt->bindParam(":end_date", $_GET['end_date']);
}

$stmt->execute();

$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode([
    "success" => true,
    "data" => $transactions
]);
?>
