<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->user_id) && !empty($data->type) && !empty($data->amount) && !empty($data->category)) {
    $query = "INSERT INTO transactions (user_id, type, amount, category, description, date) 
              VALUES (:user_id, :type, :amount, :category, :description, :date)";
    
    $stmt = $db->prepare($query);
    
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":type", $data->type);
    $stmt->bindParam(":amount", $data->amount);
    $stmt->bindParam(":category", $data->category);
    $stmt->bindParam(":description", $data->description);
    $date = isset($data->date) ? date('Y-m-d', strtotime($data->date)) : date('Y-m-d');
    $stmt->bindParam(":date", $date);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Transaksi berhasil ditambahkan",
            "id" => $db->lastInsertId()
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Gagal menambahkan transaksi"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Data tidak lengkap"
    ]);
}
?>
