<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die(json_encode(["success" => false, "message" => "User ID required"]));
$start_month = isset($_GET['start_month']) ? $_GET['start_month'] : date('Y-m', strtotime('-5 months'));
$end_month = isset($_GET['end_month']) ? $_GET['end_month'] : date('Y-m');

$query = "SELECT 
            DATE_FORMAT(date, '%Y-%m') as month,
            SUM(CASE WHEN type = 'income' THEN amount ELSE 0 END) as income,
            SUM(CASE WHEN type = 'expense' THEN amount ELSE 0 END) as expense
          FROM transactions 
          WHERE user_id = :user_id 
          AND DATE_FORMAT(date, '%Y-%m') BETWEEN :start_month AND :end_month
          GROUP BY DATE_FORMAT(date, '%Y-%m')
          ORDER BY month";

$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);
$stmt->bindParam(":start_month", $start_month);
$stmt->bindParam(":end_month", $end_month);

$stmt->execute();

$stats = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode([
    "success" => true,
    "data" => $stats
]);
?>
