<?php
require_once '../config/database.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

$database = new Database();
$db = $database->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['user_id'] ?? null;
    
    if (!$user_id) {
        echo json_encode(["success" => false, "message" => "User ID required"]);
        exit;
    }

    if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $_FILES['photo']['name'];
        $filetype = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (!in_array($filetype, $allowed)) {
            echo json_encode(["success" => false, "message" => "Format file tidak didukung"]);
            exit;
        }
        
        $maxsize = 5 * 1024 * 1024; // 5MB
        if ($_FILES['photo']['size'] > $maxsize) {
            echo json_encode(["success" => false, "message" => "File terlalu besar (max 5MB)"]);
            exit;
        }
        
        // Create uploads directory if not exists
        $upload_dir = '../uploads/profiles/';
        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        
        // Generate unique filename
        $new_filename = 'profile_' . $user_id . '_' . time() . '.' . $filetype;
        $upload_path = $upload_dir . $new_filename;
        
        if (move_uploaded_file($_FILES['photo']['tmp_name'], $upload_path)) {
            // Delete old photo
            $query = "SELECT photo_url FROM users WHERE id = :user_id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
            $old_data = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($old_data && $old_data['photo_url']) {
                $old_file = '../' . $old_data['photo_url'];
                if (file_exists($old_file)) {
                    unlink($old_file);
                }
            }
            
            // Update database
            $photo_url = 'uploads/profiles/' . $new_filename;
            $query2 = "UPDATE users SET photo_url = :photo_url WHERE id = :user_id";
            $stmt2 = $db->prepare($query2);
            $stmt2->bindParam(":photo_url", $photo_url);
            $stmt2->bindParam(":user_id", $user_id);
            
            if ($stmt2->execute()) {
                echo json_encode([
                    "success" => true,
                    "message" => "Foto berhasil diupload",
                    "photo_url" => $photo_url
                ]);
            } else {
                echo json_encode(["success" => false, "message" => "Gagal update database"]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "Gagal upload file"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Tidak ada file yang diupload"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Method not allowed"]);
}
?>
