<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->id)) {
    $query = "UPDATE budgets SET 
              category = :category,
              planned_amount = :planned_amount,
              month = :month
              WHERE id = :id AND user_id = :user_id";
    
    $stmt = $db->prepare($query);
    
    $stmt->bindParam(":id", $data->id);
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":category", $data->category);
    $stmt->bindParam(":planned_amount", $data->planned_amount);
    $stmt->bindParam(":month", $data->month);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Budget berhasil diupdate"
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Gagal mengupdate budget"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "ID budget tidak ditemukan"
    ]);
}
?>
