<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die(json_encode(["success" => false, "message" => "User ID required"]));
$month = isset($_GET['month']) ? $_GET['month'] : date('Y-m');

$query = "SELECT * FROM budgets WHERE user_id = :user_id AND month = :month ORDER BY category";

$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);
$stmt->bindParam(":month", $month);

$stmt->execute();

$budgets = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode([
    "success" => true,
    "data" => $budgets
]);
?>
